***************************************************************
* Read in data
***************************************************************

set more off
clear
* Put name of your main directory path here:
local main = "___"
cd `main'
use data_quarterly.dta, clear

***************************************************************
* Set color scheme (optional)
***************************************************************

set scheme s1color

***************************************************************
* Chart
***************************************************************

label variable pe "Long-term inflation expectations"
label variable Median "Weighted-median inflation"

cap drop sample
gen sample = 1 if (t>=tq(2000q1) & t<=tq(2022q3))
line pe Median t if sample==1, ///
lcolor(blue red) lpattern(solid dash) lwidth(medthick medthick) ///
xtitle("") xtitle("") ///
xmtick(#20) xlabel(, format(%tqCY)) xlabel(,labsize(medium)) ylabel(,labsize(medium)) xtitle("") ytitle("") ///
legend(row(3) symxsize(4) ring(0) position(11) bmargin(none) region(style(none))) xsize(5)
clist t pe Median t, noobs
keep if sample == 1
outsheet pe Median t using "results\charts\Figure 2.xls", replace

